/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, net.minecraft.world.entity.monster.ZombieVillager entity) {
        super(server, (Zombie)entity);
    }

    public net.minecraft.world.entity.monster.ZombieVillager getHandle() {
        return (net.minecraft.world.entity.monster.ZombieVillager)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVillagerZombie";
    }

    @Override
    public EntityType getType() {
        return EntityType.ZOMBIE_VILLAGER;
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return Villager.Profession.valueOf(Registry.f_122869_.m_7981_((Object)this.getHandle().m_7141_().m_35571_()).m_135815_().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().m_141967_(this.getHandle().m_7141_().m_35565_((VillagerProfession)Registry.f_122869_.m_7745_(new ResourceLocation(profession.name().toLowerCase(Locale.ROOT)))));
    }

    @Override
    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf(Registry.f_122868_.m_7981_((Object)this.getHandle().m_7141_().m_35560_()).m_135815_().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().m_141967_(this.getHandle().m_7141_().m_35567_((VillagerType)Registry.f_122868_.m_7745_(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().m_34408_();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().f_34365_;
    }

    @Override
    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().f_34365_ = -1;
            this.getHandle().m_20088_().m_135381_(net.minecraft.world.entity.monster.ZombieVillager.f_34359_, (Object)false);
            this.getHandle().f_34360_ = null;
            this.getHandle().removeEffect(MobEffects.f_19600_, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().m_34383_((UUID)null, time);
        }
    }

    @Override
    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().f_34360_ == null ? null : Bukkit.getOfflinePlayer(this.getHandle().f_34360_);
    }

    @Override
    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().f_34360_ = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

